//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;
using System.Reflection;
using System.Runtime.Remoting;
using InterAppDomain;

namespace AppDomainTest
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class InterAppDomain
	{
		static void Main(string[] args)
		{
			// Ustawienie ApplicationBase na aktualny katalog

			AppDomainSetup info = new AppDomainSetup();

			info.ApplicationBase = "file:\\\\" + System.Environment.CurrentDirectory;

			// Utworzenie domeny aplikacji z pustym dowodem

			AppDomain dom = AppDomain.CreateDomain("RemoteDomain", null, info);

			// Zaadowanie podzespou HelloWorld2 i utworzenie egzemplarza
			// typu HelloWorld
			BindingFlags flags = (BindingFlags.Public | BindingFlags.Instance | BindingFlags.CreateInstance);
			ObjectHandle objh = dom.CreateInstance("Fault", "InterAppDomain.Fault", false, flags, null, null, null, null, null);
			if (objh == null) 
			{
				Console.WriteLine("Dziaanie CreateInstance nie powiodo si");
				return;
			}

			// Odpakowanie obiektu
			Object obj = objh.Unwrap();

			// Rzutowanie do aktualnego typu
			Fault f = (Fault)obj;

			Console.WriteLine("W domenie aplikacji: {0} wtek {1}", Thread.GetDomain().FriendlyName, Thread.CurrentThread.GetHashCode());

			try
			{
				// Wywoanie metody
				// f.DivideZero();
				f.Exception();
			}
			catch(Exception e)
			{
				Console.WriteLine(e.ToString());
			}

			// Oczyszczenie poprzez usunicie domeny aplikacji z pamici
			AppDomain.Unload(dom);  

		}
	}
}
